﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Default" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Ei8ht POS</title>
    <link id="Link1" rel="icon" type="image/ico" href="~/Admin/Images/favicon.ico" runat="server" />
    <link href="Styles/vendor/bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="http://netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet" />
    <link href="Styles/minimal.css" rel="stylesheet" />
    <script src="http://code.jquery.com/jquery.js"></script>
    <script src="Scripts/vendor/bootstrap/bootstrap.min.js"></script>
    <script>
        function ShowAlert(msg, title) {
            $('#divMessage h4.modal-title').text(title);
            $('#divMessage div.modal-body').text(msg);
            $('#divMessage').modal();
        }

        function validateUI() {
            if ($.trim($('#<%= txtPassword.ClientID %>').val()) == '' || $.trim($('#<%= txtUsername.ClientID %>').val()) == '') {
                ShowAlert('Please enter a valid Username and password before proceeding to Login', 'Ei8ht POS - Login');
                event.preventDefault();
            }
            return true;
        }
    </script>
</head>
<body class="bg-cafe">
    <form id="formsignin" class="form-signin" runat="server">
        <!-- Wrap all page content here -->
        <div id="wrap">
            <!-- Make page fluid -->
            <div class="row">
                <!-- Page content -->
                <div id="content" class="col-md-12 full-page login">


                    <div class="inside-block">

                        <img src="/Admin/Images/logo.png" class="logo" />
                        <h1><strong>Welcome!</strong></h1>
                        <br />
                        <h4>Ei8ht POS for Retail
                            <br />
                            Web Version 1.0.0</h4>
                        <br />
                        <section>
                            <div class="input-group">

                                <asp:TextBox ID="txtUsername" runat="server" placeholder="Username" CssClass="nocurves" Style="width: 100%;" />
                                <div class="input-group-addon"><i class="fa fa-user"></i></div>
                            </div>
                            <br />
                            <div class="input-group">
                                <asp:TextBox TextMode="Password" ID="txtPassword" placeholder="Password" CssClass="nocurves" runat="server" Style="width: 100%;" />
                                <div class="input-group-addon"><i class="fa fa-key"></i></div>
                            </div>
                            <br />

                        </section>
                        <section class="log-in">
                            <asp:Button runat="server" ID="btnLogin" Text="Login" CssClass="btn btn-primary tSize18 text-center btn-lg" OnClientClick="return validateUI();" OnClick="btnLogin_Click" Width="100%" />
                        </section>
                        <br />
                        <section class="controls">
                            <a class="cwhite pull-right" data-toggle="modal" href="#" data-target="#divForgotPassword">Forgot Password</a>
                        </section>
                    </div>


                </div>
                <!-- /Page content -->
            </div>
        </div>
        <!-- Wrap all page content end -->
        <%--Forgot Password--%>
        <div class="modal fade" id="divForgotPassword" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="myModalLabel">Forgot Password</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12 col-xs-12">
                                <div class="col-md-12 col-xs-12">
                                    <asp:Label runat="server" ID="lblFError" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">Enter Username</div>
                            <div class="col-md-6 col-xs-12">
                                <asp:TextBox runat="server" ID="txtFUserName" CssClass="nocurves" />
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <a id="A1" class="btn btn-danger" runat="server" onserverclick="btnForgetPassword_Click">Retrieve Password</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                    </div>
                </div>
            </div>
        </div>
        <%--Alert Popup--%>
        <div class="modal fade" id="divMessage" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H1"></h4>
                    </div>
                    <div class="modal-body">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
